﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductSubCategoryBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductSubCategory GetItem(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            return ProductSubCategoryDB.GetItem(productSubCategoryID, productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductSubCategory> GetList(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            return ProductSubCategoryDB.GetList(productSubCategoryID, productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            return ProductSubCategoryDB.GetDataTable(productSubCategoryID, productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            return ProductSubCategoryDB.GetDataSet(productSubCategoryID, productCategoryID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductSubCategory myProductSubCategory)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductSubCategoryDB.Save(myProductSubCategory);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
